﻿//////////////////////////////////////////////
// DdsSurfaceDetail.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Class ------------------------------------

namespace nkImages::dds
{
	enum class DDS_SURFACE_DETAIL : unsigned int
	{
		DDS_SURFACE_DETAIL_UNKNOWN = 0,
		DDSCAPS2_CUBEMAP = 0x200,
		DDSCAPS2_CUBEMAP_POSITIVEX = 0x400,
		DDSCAPS2_CUBEMAP_NEGATIVEX = 0x800,
		DDSCAPS2_CUBEMAP_POSITIVEY = 0x1000,
		DDSCAPS2_CUBEMAP_NEGATIVEY = 0x2000,
		DDSCAPS2_CUBEMAP_POSITIVEZ = 0x4000,
		DDSCAPS2_CUBEMAP_NEGATIVEZ = 0x8000,
		DDSCAPS2_VOLUME = 0x200000
	} ;

	inline DDS_SURFACE_DETAIL operator& (DDS_SURFACE_DETAIL a, DDS_SURFACE_DETAIL b)
	{
		return (DDS_SURFACE_DETAIL)((unsigned int)a & (unsigned int)b) ;
	}

	inline DDS_SURFACE_DETAIL operator| (DDS_SURFACE_DETAIL a, DDS_SURFACE_DETAIL b)
	{
		return (DDS_SURFACE_DETAIL)((unsigned int)a | (unsigned int)b) ;
	}
}